/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.util;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCleanUp {
    public Document clean(Document doc) {
        this.removeEmptyChlidElements(doc.getDocumentElement());
        return doc;
    }

    private void removeEmptyChlidElements(Element parentElement) {
        ArrayList<Element> toRemove = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int childrenCount = children.getLength();
        int i = 0;
        while (i < childrenCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                this.removeEmptyChlidElements(childElement);
                if (this.elementIsRedundant(childElement)) {
                    toRemove.add(childElement);
                }
            }
            ++i;
        }
        for (Element childElement : toRemove) {
            parentElement.removeChild(childElement);
        }
        parentElement.normalize();
    }

    private boolean elementIsRedundant(Element element) {
        if (element.hasAttributes()) {
            return false;
        }
        if (element.hasChildNodes()) {
            return false;
        }
        NodeList children = element.getChildNodes();
        int chlidreCount = children.getLength();
        int i = 0;
        while (i < chlidreCount) {
            Node child = children.item(i);
            String value = child.getNodeValue();
            if (value != null && value.matches("\\s*")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

